//-----------------------------------------------------------------------------
// zAnswer - EasyStep type answer link with bullet
//-----------------------------------------------------------------------------
function zAnswer( id, label, css, bBackBullet, act )
{
	this.id=id;
	this.label=label;
	if( css ) this.css = css;
	if( bBackBullet ) this.bBackBullet = true;
	if( act ) this.act = act;
}

//-----------------------------------------------------------------------------
function _zAnswerRender()
{
	if( !this.id ) return "&nbsp;";

	var act = (this.act) ? this.act : 'onAnswerNext(\'' + this.id + '\')';
	var bullet = (this.bBackBullet) ? "../img/backbullet.gif" : "../img/bullet.gif";
	var bullet_h = (this.bBackBullet) ? "../img/backbullet_h.gif" : "../img/bullet_h.gif";
	
	var s = '<a href="javascript:;" onclick="' + act + '" onkeyup="onAnswerKeyUp(this)" style="cursor:hand">';
		
	s += '<table';
	if( this.css ) s += ' class="' + this.css + '"';
	s += ' cols="2" cellspacing="0" cellpadding="0" border="0" onmouseout="onAnswerHover(this)" onmouseover="onAnswerHover(this)">';

	s += '<tbody><tr valign="top"><td class="bullet">';
	s += '<img src="'+bullet+'" normalSrc="'+bullet+'" hoverSrc="'+bullet_h+'" border="0">';
	s += '</td><td class="btnLabel" normalCss="btnLabel" hoverCss="btnLabel_h">'
	s += this.label+'</td>';
	s += '</tr></tbody></table>';
	
	s += '</a>';

	return s;
}

//-----------------------------------------------------------------------------
p = zAnswer.prototype;
p.css = null;
p.bBackBullet = false;
p.act = null;
p.render = _zAnswerRender;

p = null;

//-----------------------------------------------------------------------------
function appendAnswers( answers )
	// Renders inline a row of answer buttons to the document
{
	if(!answers)return;
	
	var cnt = answers.length;
	
	var s='<table id="btns" class="btns" cellspacing="0" cellpadding="0" border="0"><tbody><tr>';
	for( var i=0; i < cnt; ++i )
	{
		s += '<td'
		if( i>0 ) s += ' align="right"';
		s += '>';
		s += answers[i].render();
		s += '</td>';
	}
	s+='</tr></tbody></table>';
	
	document.write(s);
}

//-----------------------------------------------------------------------------
function appendVAnswers( css, answers )
	// Renders inline a set of buttons aligned vertically on top of each other
{
	if(!answers)return;
	
	var s='<table class="'+css+'" cols="2" cellspacing="0" cellpadding="0" border="0"><tbody>';
	for( var i in answers )
	{
		if( !answers[i].id ) continue;
		
		s += '<tr valign="top" class="vBtn"><td>';
		s += answers[i].render();
		s += '</td></tr>';
	}
	s+='</tbody></table>';
	
	document.write(s);
}

//-----------------------------------------------------------------------------
function onAnswerHover(e)
	// Handles a mouse hover over an answer button.
	// Glows both the bullet and label
{
	if (!e) return;
	
	var evt = window.event;
	if(!evt) return;
	var bOver = ( evt.type == "mouseover" );
	
	if(!e.tBodies)return;
	var tbody = e.tBodies[0];
	
	var bullet = tbody.rows[0].cells[0].firstChild;
	bullet.src = ( bOver ) ? bullet.hoverSrc : bullet.normalSrc;
	
	var label = tbody.rows[0].cells[1];
	label.className = ( bOver ) ? label.hoverCss : label.normalCss;
}

//-----------------------------------------------------------------------------
function onVAnswerHover(e)
	// Handles a mouse hover over an answer button.
	// Glows both the bullet and label
{
	if(!e) return;
	if(!e.cells)return;
	
	var evt = window.event;
	if(!evt) return;
	var bOver = ( evt.type == "mouseover" );
		
	var bullet = e.cells[0].firstChild;
	bullet.src = ( bOver ) ? bullet.hoverSrc : bullet.normalSrc;
	
	var label = e.cells[1];
	label.className = ( bOver ) ? label.hoverCss : label.normalCss;
}

//-----------------------------------------------------------------------------
function onAnswerNext(id) { if(parent) parent.onNext(id); }
	// Determines the next page to display depending on the button clicked and
	// displays the next page.
	
//-----------------------------------------------------------------------------
function onAnswerKeyUp( e )
	// Invoke the click event if space or enter key is pressed
{
	if( !e ) return;
	
	var evt = window.event;
	if( !evt ) return;
	if( 13 == evt.keyCode || 32 == evt.keyCode ) e.fireEvent("onclick");
}	
